<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group_Battles_Leaderboard extends Model
{
    use HasFactory;

    protected $table = 'tbl_group_battles_leaderboard';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'group_battles_id' => 'integer',
        'user_id' => 'integer',
        'is_creator' => 'integer',
        'questions_attended' => 'integer',
        'correct_answers' => 'integer',
        'percentage' => 'integer',
        'is_winner' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
